#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Growing FernMod01.fsh  by   Bleuje  
//https://www.shadertoy.com/view/.....
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// by @etiennejcb

#define otherDesign false
#define ratio 0.55
#define r0 0.5
#define duration 3.0
#define AA true
#define horizontalScroll false
#define shake false

#define PI 3.14159
#define TAU (2.*PI)

float time;

vec2 spiralCoord(vec2 uv)
{
    float theta0 = atan(uv.y,uv.x);
    // r = r0*pow(ratio,it+theta0/TAU);
    // log_ratio(r/r0)-theta0/TAU = it
    float it = log(length(uv)/r0)/log(ratio)-theta0/TAU;
    float it_small = floor(it);
    float it_big = it_small+1.;
    float r_small = r0*pow(ratio,it_small+theta0/TAU);
    float r_big = r0*pow(ratio,it_big+theta0/TAU);
    float r = length(uv);
    // (1-p)*r_small + p*r_big = r
    // p*(r_big - r_small) = r - r_small
    // p = (r - r_small)/(r_big - r_small)
    float p = (r - r_small)/(r_big - r_small);
    float theta = TAU*it_small + theta0;
    return vec2(p,theta);
}
//---start buffer prevoid---//
// Dave Hoskins
// https://www.shadertoy.com/view/4djSRW
float hash12(vec2 p)
{
	vec3 p3  = fract(vec3(p.xyx) * .1031);
    p3 += dot(p3, p3.yzx + 33.33);
    return fract((p3.x + p3.y) * p3.z);
}

// 3d simplex noise from https://www.shadertoy.com/view/XsX3zB

/* discontinuous pseudorandom uniformly distributed in [-0.5, +0.5]^3 */
vec3 random3(vec3 c) {
	float j = 4096.0*sin(dot(c,vec3(17.0, 59.4, 15.0)));
	vec3 r;
	r.z = fract(512.0*j);
	j *= .125;
	r.x = fract(512.0*j);
	j *= .125;
	r.y = fract(512.0*j);
	return r-0.5;
}

/* skew constants for 3d simplex functions */
const float F3 =  0.3333333;
const float G3 =  0.1666667;

/* 3d simplex noise */
float simplex3d(vec3 p) {
	 /* 1. find current tetrahedron T and it's four vertices */
	 /* s, s+i1, s+i2, s+1.0 - absolute skewed (integer) coordinates of T vertices */
	 /* x, x1, x2, x3 - unskewed coordinates of p relative to each of T vertices*/
	 
	 /* calculate s and x */
	 vec3 s = floor(p + dot(p, vec3(F3)));
	 vec3 x = p - s + dot(s, vec3(G3));
	 
	 /* calculate i1 and i2 */
	 vec3 e = step(vec3(0.0), x - x.yzx);
	 vec3 i1 = e*(1.0 - e.zxy);
	 vec3 i2 = 1.0 - e.zxy*(1.0 - e);
	 	
	 /* x1, x2, x3 */
	 vec3 x1 = x - i1 + G3;
	 vec3 x2 = x - i2 + 2.0*G3;
	 vec3 x3 = x - 1.0 + 3.0*G3;
	 
	 /* 2. find four surflets and store them in d */
	 vec4 w, d;
	 
	 /* calculate surflet weights */
	 w.x = dot(x, x);
	 w.y = dot(x1, x1);
	 w.z = dot(x2, x2);
	 w.w = dot(x3, x3);
	 
	 /* w fades from 0.6 at the center of the surflet to 0.0 at the margin */
	 w = max(0.6 - w, 0.0);
	 
	 /* calculate surflet components */
	 d.x = dot(random3(s), x);
	 d.y = dot(random3(s + i1), x1);
	 d.z = dot(random3(s + i2), x2);
	 d.w = dot(random3(s + 1.0), x3);
	 
	 /* multiply d by w^4 */
	 w *= w;
	 w *= w;
	 d *= w;
	 
	 /* 3. return the sum of the four surflets */
	 return dot(d, vec4(52.0));
}
//---end prevoid buffer---//

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = fragCoord/iResolution.xy;
    uv -= 0.5;
	uv.x *= iResolution.x / iResolution.y;
    
    if(horizontalScroll) time = iTime/duration;
    else time = mod(iTime,duration)/duration;
    
    if(shake)
    {
        float shakeSpeed = 1.5;
        uv += 0.01*vec2(simplex3d(vec3(shakeSpeed*cos(TAU*time),shakeSpeed*sin(TAU*time),0.)),simplex3d(vec3(shakeSpeed*cos(TAU*time),shakeSpeed*sin(TAU*time),100.456)));
    }
    uv.y -= 0.1;
    
    vec3 background = vec3(0.5,0.8,1.0)*(1.5+0.7*uv.y);
    // sunset version :
    //vec3 background = vec3(1.0,0.7,0.2)*(1.5+0.7*uv.y);
    
    vec3 col = background;
    
    float nbIterations = 7.0;
    
    for(float it=0.;it<nbIterations;it++)
    {
        float pw = 1.7;
        float reduction = pow(pw,it);
        
        vec2 uv2 = uv+vec2((horizontalScroll?0.45/reduction*time:0.),0.);
        vec2 pos = 2.75*uv2*reduction;
        
        float rl = (otherDesign?1.0:1.3*pow(1.3,it));
        pos.x += (mod(it,2.0)>0.?rl/2.0:0.);
        
        pos.x += rl*simplex3d(vec3(1234.789,333.333*it,0.));
        
        float ind = floor((pos.x+rl/2.0)/rl);
        pos.x = mod(pos.x+rl/2.0,rl)-rl/2.0;
        
        float sv = 0.055*sin(TAU*(time + hash12(vec2(ind,it+123.))));
        
        pos.y += (mod(it,2.0)>0.?0.9:0.) + sv - pow(pw,it)*1.1*simplex3d(vec3(100.*ind,333.333*it,230.));
        if(mod(ind,2.0)>0.) pos.x = -pos.x;
        
        vec2 pt = spiralCoord(pos);

        bool ok = true;
        if(pt.y<0.)
        {
            float factor = 0.03;
            float left = (r0*ratio+factor*pos.y);
            float right = r0-factor*pos.y;
            pt.x = 1.-(pos.x - left)/(right - left);
            pt.y = PI*pos.y;
            if(pt.y>0.|| pt.x<0.||pt.x>1.) ok = false;
        }
        if(ok){
            float indx = floor(pt.x/0.25);
            float indy = floor(3.*iTime+pt.y/TAU/0.035);
            float type = mod(indx+indy,2.0);

            float rad = 1.0;
            float offset = -0.1*pt.y;
            float scl = 15.0;

            float val1 = simplex3d(vec3(125.*it+rad*cos(TAU*(time-offset)),65.987*ind+rad*sin(TAU*(time-offset)),scl*pt.x));
            float val2 = simplex3d(vec3(125.*it+111.111+rad*cos(TAU*(time-offset)),163.987*ind+rad*sin(TAU*(time-offset)),scl*pt.x));
            float val3 = simplex3d(vec3(125.*it+222.222+rad*cos(TAU*(time-offset)),265.987*ind+rad*sin(TAU*(time-offset)),scl*pt.x));
            
            float a = 4.0*pow(max(-0.5,(val1+val2+val3)*0.5),3.0);
            col = vec3(0.38-a,0.73-0.1*hash12(vec2(ind,it))-a,0.1);


            if(min(pt.x,1.-pt.x)<0.07+0.02*it) col = vec3(0.,0.2,0.);
             
            float fog = it/(nbIterations+1.0); 
            
            col = clamp(mix(col,background,fog),0.,1.);

            break;
        }
    }


    // Output to screen
    fragColor = vec4(col,1.0);


// smart AA, from FabriceNeyret2
//void mainImage(out vec4 O, vec2 U) {
//    mainImage0(O,U);
//    if(AA)
//    if ( fwidth(length(O)) > .01 ) {  // difference threshold between neighbor pixels
//        vec4 o;
//        for (int k=0; k < 9; k+= k==3?2:1 )
//          { mainImage0(o,U+vec2(k%3-1,k/3-1)/3.); O += o; }
//        O /= 9.;
//     // O.r++;                        // uncomment to see where the oversampling occurs
//    }
//}
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

